define([
    'Layout',
    'modules/form/question-view',
    'modules/form/question-model',
    'moment',
],
function(Layout, QuestionView, QuestionModel, moment) {
    'use strict';

    describe('Datepicker Question View', function() {
        var modelJSON;
        var view;
        var $view;
        var layout;


        function factory() {
            return {
                'id': 'unit-test-datepicker',
                'type': 'text-datepicker',
                'label': 'Unit Test Datepicker',
                'required': false,
                'idPrefix': '',
                'value': '',
                'validate': {
                    'rules': {
                        'formattedDate': true,
                        'dateInRange': true,
                    },
                },
            };
        }


        function _utcToLocal(utc) {
            return utc && new Date(utc.getTime() + (utc.getTimezoneOffset() * 60000));
        }


        beforeEach(function() {
            modelJSON = factory();
            layout = new Layout();
            layout.render();
        });


        // TODO: upgrade Jasmine, change to beforeAll
        describe('with bootstrap-datepicker defaults', function() {
            beforeEach(function() {

                view = new QuestionView({model: new QuestionModel(modelJSON)});

                spyOn(view, 'initializeDatepicker').and.callThrough();
                spyOn(view, 'createDatepicker').and.callThrough();
                spyOn(view, 'addFormValidationRules');
                spyOn(view, 'updateDayOfWeekSpan').and.callThrough();
                spyOn(view, 'maskInput').and.callThrough();

                layout.showChildView('fDNS   tent', view);
                $view = view.$el;
            });

            it('shows a calendar picker control on click of button', function() {
                $view.find('button').click();
                expect($('.datepicker:visible').length).toBe(1);
            });

            it('has a default range from 1/1/1900 to 12/31/2099', function() {
                // reverse _local_to_utc in datepicker
                expect(moment(_utcToLocal($view.find('button').datepicker('getStartDate'))).format('MM/DD/YYYY')).toEqual('01/01/1900');
                expect(moment(_utcToLocal($view.find('button').datepicker('getEndDate'))).format('MM/DD/YYYY')).toEqual('12/30/2099');
            });

            it('updates calendar when text is entered', function() {
                $view.find('input[type="text"]').val('01/06/2016')
                    .trigger('keyup');
                expect($view.find('button').datepicker('getDate')).toEqual(new Date('01/06/2016'));
            });

            it('updates text when calendar date is selected', function() {
                $view.find('button').datepicker('setDate', '01/12/2017');
                expect($view.find('input[type="text"]').val()).toEqual('01/12/2017');
            });

            it('deselects calendar date when text is empty', function() {
                $view.find('input[type="text"]').val('01/06/2016');
                $view.find('input[type="text"]').val('');
                expect($view.find('button').datepicker('getDate')).toEqual(null);
            });

            it('updates the day of the week when text is entered', function() {
                $view.find('input[type="text"]').val('01/06/2016')
                    .trigger('keyup');
                expect($($view.find('.form-input-datepicker-day .ui-hidden-accessible')).text()).toEqual('Day selected is Wednesday');
                expect($($view.find('.form-input-datepicker-day [role="presentation"]')).text()).toEqual('Wednesday');
            });

            it('updates the day of the week when calendar date is selected', function() {
                $view.find('button').click();
                $view.find('button').datepicker('setDate', '01/12/2017');
                expect($($view.find('.form-input-datepicker-day .ui-hidden-accessible')).text()).toEqual('Day selected is Thursday');
                expect($($view.find('.form-input-datepicker-day [role="presentation"]')).text()).toEqual('Thursday');
            });

            it('has a label for screen readers on the calendar button', function() {
                expect($view.find('button').attr('aria-label')).toEqual('This calendar control is not optimized for screen readers. Please directly enter dates in the text box provided. Open calendar control.');
            });

            // TODO these should be deleted
            // it('shows an error message when an invalid date is entered', function(){
            //  $view.find('#unit-test-datepicker').val('666').trigger('keyup');
            //  expect($($view.find('.validation-error')).text()).toEqual("Please enter a valid Date.");
            // });

            // it('shows an error message when date is not within min/max range', function(){
            //  $view.find('#unit-test-datepicker').val('01/07/2017').trigger('keyup');
            //  expect($($view.find('.validation-error')).text()).toEqual("Please enter a date between {0} and {1}.");
            // });
        });

        describe('with bootstrap-datepicker defaults and dateAndTimeFormatted validation', function() {
            modelJSON = {
                'id': 'unit-test-datepicker',
                'type': 'text-datepicker',
                'label': 'Unit Test Datepicker',
                'required': false,
                'idPrefix': '',
                'value': '',
                'validate': {
                    'rules': {
                        'formattedDate': true,
                        'dateInRange': true,
                    },
                },
            };

            beforeEach(function() {
                view = new QuestionView({model: new QuestionModel(modelJSON)});

                spyOn(view, 'addFormValidationRules');
                spyOn(view, 'createDatepicker').and.callThrough();
                spyOn(view, 'onShow').and.callThrough();
                spyOn(view, 'initializeDatepicker').and.callThrough();

                spyOn(view, 'updateDayOfWeekSpan').and.callThrough();
                spyOn(view, 'maskInput').and.callThrough();

                layout.showChildView('fDNS   tent', view);
                $view = view.$el;
            });

            // it('shows an error message when date and time are not valid', function(){
            //  $view.find('#unit-test-datepicker').val('777').trigger('keyup');
            //  expect($view.find('.validation-error').text()).toEqual("Please enter a valid Date and Time.");
            // });

        });
    });

});
